<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
         Schema::create('settings', function (Blueprint $table) {
            $table->id();
            $table->string('api_key')->unique();       // کلید تنظیمات مثل 'api_frontend'
            $table->text('api_value')->nullable();     // مقدار تنظیمات، می‌تواند هر نوع داده باشد
            $table->string('api_sms_faraz')->nullable();     // مقدار تنظیمات، می‌تواند هر نوع داده باشد

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('settings');
    }
};
