<?php

namespace App\Services\wallet;

use App\Models\User;
use App\Models\UserVerification;
use Carbon\Carbon;
use App\Models\Currency;
use App\Models\Wallet;
use Illuminate\Support\Str;
class WalletService
{
        public function createOrUpdateWallet(int $userId, int $currencyId, string $type): Wallet
    {
        // بررسی وجود کیف پول قبلی
        $wallet = Wallet::where('user_id', $userId)
                        ->where('currency_id', $currencyId)
                        ->first();

        if (!$wallet) {
            // تولید آدرس یکتا
            $address = $this->generateUniqueAddress($userId, $currencyId);

            $wallet = Wallet::create([
                'user_id' => $userId,
                'currency_id' => $currencyId,
                'type' => $type,
                'address' => $address,
                'balance' => 0,
                'balance_frozen' => 0,
                'is_active' => true,
            ]);
        }

        return $wallet;
    }

    /**
     * ایجاد کیف پول‌های ضروری برای یک کاربر
     *
     * @param int $userId
     * @return void
     */
    public function createEssentialWalletsForUser(int $userId): void
    {
        $essentialCurrencies = Currency::where('is_essential', true)
                                       ->where('is_active', true)
                                       ->get();

        foreach ($essentialCurrencies as $currency) {
            $type = $currency->type === 'crypto' ? 'crypto' : 'fiat';

            $exists = Wallet::where('user_id', $userId)
                            ->where('currency_id', $currency->id)
                            ->exists();

            if (!$exists) {
                $this->createOrUpdateWallet($userId, $currency->id, $type);
            }
        }
    }

    /**
     * تولید آدرس یکتا برای کیف پول
     *
     * @param int $userId
     * @param int $currencyId
     * @return string
     */
    protected function generateUniqueAddress(int $userId, int $currencyId): string
    {
        do {
             $uuid = Str::uuid()->toString();
             $shortUuid = substr($uuid, 0, 8);
             $address = "WLT-{$userId}-{$currencyId}-{$shortUuid}";
           } while (Wallet::where('address', $address)->exists());

         return $address;
    }
}
