<?php

namespace App\Services\verify;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use App\Models\User;
use App\Models\UserVerification;
class ZibalService
{
    protected $token;

    public function __construct()
    {
        $this->token = env('ZIBAL_API_TOKEN');  // تو فایل .env مقدارش رو تعریف کن
    }


    public function verifyNationalIdentity(string $nationalCode, string $birthDate): bool
    {
        $url = 'https://api.zibal.ir/v1/facility/nationalIdentityInquiry/';

        $birthDateFormatted = str_replace('-', '/', $birthDate);
        $birthDateFormatted = strtok($birthDateFormatted, ' ');

        $response = Http::withHeaders([
            'Authorization' => 'Bearer ' . $this->token,
            'Accept' => 'application/json',
        ])->post($url, [
            'nationalCode' => $nationalCode,
            'birthDate' => $birthDateFormatted,
        ]);

        if (!$response->successful()) {
            throw new \Exception('خطا در ارتباط با سرویس زبایل برای ملیت');
        }

        $data = $response->json();

        if (isset($data['result']) && ($data['result'] == 1 || $data['result'] === true)) {
            if (isset($data['data']['matched']) && $data['data']['matched'] === true) {
                return true;
            }
        }

        throw new \Exception('اطلاعات هویتی اشتباه است.');
    }

    /**
     * بررسی تطبیق شماره موبایل با nationalCode
     * @param string $nationalCode
     * @param string $mobile
     * @return bool
     * @throws \Exception
     */
    public function verifyMobileWithShahkar(string $nationalCode, string $mobile): bool
    {
        $url = 'https://api.zibal.ir/v1/facility/shahkarInquiry';

        $response = Http::withHeaders([
            'Authorization' => 'Bearer ' . $this->token,
            'Accept' => 'application/json',
        ])->post($url, [
            'nationalCode' => $nationalCode,
            'mobile' => $mobile,
        ]);

        if (!$response->successful()) {
            throw new \Exception('خطا در ارتباط با سرویس زبایل برای شاهکار');
        }

        $data = $response->json();

        if (isset($data['result']) && ($data['result'] == 1 || $data['result'] === true)) {
            if (isset($data['data']['matched']) && $data['data']['matched'] === true) {
                return true;
            }
        }

        throw new \Exception('موبایل نامعتبر است.');
    }

    /**
     * متد اصلی که کل روند رو اجرا می‌کند و وضعیت را ذخیره می‌کند
     * @param string $nationalCode
     * @param string $birthDate
     * @param string $mobile
     * @return bool
     * @throws \Exception
     */
    public function verifyUserIdentity(string $nationalCode, string $birthDate, string $mobile): bool
    {
        // ابتدا ملیت را چک می‌کنیم
        $this->verifyNationalIdentity($nationalCode, $birthDate);

        // سپس موبایل را چک می‌کنیم
        $this->verifyMobileWithShahkar($nationalCode, $mobile);

        // اگر هر دو درست بود، وضعیت را در دیتابیس ذخیره می‌کنیم

        $verification = UserVerification::where('national_code', $nationalCode)->first();
        $user = User::where('national_code',$nationalCode)->first();
        if (!$verification) {
            // اگر رکورد نبود، ایجاد می‌کنیم
            $verification = new UserVerification();
            $verification->user_id = $user->id;
            $verification->national_code = $nationalCode;
            $verification->mobile = $mobile;
        }

        $verification->profile_status = 'approved';
        $verification->profile_verified_at = now();
        $verification->save();

        return true;
    }
}
