<?php

namespace App\Services\sms;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;

class SmsFarazService
{
    protected $apiKey;
    protected $apiUrl;

    public function __construct()
    {
        $this->apiKey = $this->getApiKeyFromSettings();
        $this->apiUrl = 'https://api2.ippanel.com/api/v1/sms/pattern/normal/send';
    }

    /**
     * گرفتن کلید api_sms_faraz از جدول settings
     *
     * @return string|null
     */
    protected function getApiKeyFromSettings()
    {
        $settings  =  DB::table('settings')->first();
        return $settings->api_sms_faraz;
    }

    /**
     * ارسال پیامک با الگو
     */
    public function sendPatternSms(string $patternCode, string $sender, string $recipient, array $variables = [])
    {
        $payload = [
            'code' => $patternCode,
            'sender' => $sender,
            'recipient' => $recipient,
            'variable' => $variables,
        ];

        $response = Http::withHeaders([
            'accept' => '*/*',
            'apikey' => $this->apiKey,
            'Content-Type' => 'application/json',
        ])->post($this->apiUrl, $payload);

        return $response;
    }
}
