<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\DB;
use App\Models\ApiRequest;
class ApiKeyRateLimit
{
    public function handle(Request $request, Closure $next)
    {

        $apiKey = $request->header('X-API-KEY');

        if (!$apiKey) {
            return response()->json(['message' => 'API key is required'], 401);
        }

        $requestType = $request->header('X-REQUEST-TYPE', 'user');

        if ($requestType === 'frontend') {
            $frontendKey = DB::table('settings')->first();
            if ($apiKey === $frontendKey->api_key) {
                // اجازه نامحدود برای فرانت‌اند
                return $next($request);
            } else {
                return response()->json(['message' => 'Invalid frontend API key'], 403);
            }
        }

        $userApi = DB::table('users_api')->where('api_key', $apiKey)->lockForUpdate()->first();

        if (!$userApi) {
            return response()->json(['message' => 'Invalid API key'], 403);
        }

        if ($userApi->number_hour <= 0) {
            $this->saveApiRequest($userApi->id, $request, false);
            return response()->json(['message' => 'Hourly API request limit exceeded'], 429);
        }

        if ($userApi->number_month <= 0) {
            $this->saveApiRequest($userApi->id, $request, false);
            return response()->json(['message' => 'Monthly API request limit exceeded'], 429);
        }

        // کم کردن تعداد ریکوست‌ها
        DB::table('users_api')->where('id', $userApi->id)->update([
            'number_hour' => $userApi->number_hour - 1,
            'number_month' => $userApi->number_month - 1,
        ]);

        $response = $next($request);

        // ذخیره درخواست موفق
        $this->saveApiRequest($userApi->id, $request, true, $response);

        return $response;



    }

    protected function saveApiRequest($userApiId, $request, $success, $response = null)
{
    ApiRequest::create([
        'user_api_id' => $userApiId,
        'method' => $request->method(),
        'url' => $request->fullUrl(),
        'success' => $success,
        'request_body' => $request->getContent(),
        'response_body' => $response ? $response->getContent() : null,
    ]);
}
}
