<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Shared\CurrencyController;
use App\Http\Controllers\Shared\CategoryController;
use App\Http\Controllers\Shared\SliderController;
use App\Http\Controllers\Shared\ItemController;
use App\Http\Middleware\ApiKeyRateLimit;




Route::middleware(ApiKeyRateLimit::class)->group(function () {
    Route::get('/shared/categories/tree', [CategoryController::class, 'tree']);
    Route::get('/shared/category/{slug}', [CategoryController::class, 'show_cat']);
    Route::get('/shared/slider', [SliderController::class, 'getSliders']);
    Route::get('/shared/items/featured', [ItemController::class, 'landing_Featured']);
    Route::get('/shared/item/{slug}', [ItemController::class, 'show_item']);
    Route::get('/shared/category/{slug}/items', [ItemController::class, 'getProductsByCategorySlug']);
});




Route::get('/shared/currency-rates', [CategoryController::class, 'fetchRates']);
