<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateInvoicesTable extends Migration
{
    public function up()
    {
        Schema::create('invoices', function (Blueprint $table) {
            $table->id();

            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('item_id');

            $table->integer('quantity')->default(1);

            $table->decimal('unit_price', 15, 2);   // قیمت هر واحد به تومان یا ارز پایه
            $table->decimal('total_price', 15, 2);  // جمع کل مبلغ

            $table->enum('payment_status', ['pending', 'paid', 'canceled'])->default('pending');
            $table->enum('order_status', ['needs_document_verification', 'processing', 'in_progress', 'completed'])->default('needs_document_verification');

            $table->string('order_number')->unique()->nullable();
            $table->string('request_type')->nullable();   // نوع درخواست (مثلاً خرید، شارژ و...)

            $table->dateTime('payment_date')->nullable(); // تاریخ پرداخت

            $table->decimal('currency_price_at_purchase', 15, 6)->nullable(); // قیمت هر واحد ارز زمان خرید، دقت بیشتر

            $table->decimal('service_fee_amount', 5, 2)->default(0);
            $table->decimal('tax_amount', 5, 2)->default(0);

            $table->string('payment_image_path')->nullable(); // مسیر تصویر پرداخت (مثلاً رسید)

            $table->timestamps();

            // کلیدهای خارجی
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('item_id')->references('id')->on('items')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('invoices');
    }
}
