<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\MorphOne;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
class Page extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'title',
        'slug',
        'short_description',
        'content',
        'is_active',
        'views',
        'thumbnail',
        'featured_image',
        'logo',
    ];

    public function seoMetadata(): MorphOne
    {
        return $this->morphOne(SeoMetadata::class, 'seoable');
    }

    public function fields()
    {
        return $this->hasMany(PageField::class);
    }

    public function fieldValues()
    {
        return $this->hasMany(PageFieldValue::class);
    }


}
