<?php
namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use App\Models\Currency;
use App\Rules\ValidUserBankAccount;

class DepositRequest extends FormRequest
{
    protected $symbol;
    protected $depositType;

    protected function prepareForValidation(): void
    {
        // اگر از query string میاد:
        $this->symbol = $this->query('symbol');
        $this->depositType = $this->query('deposit_type');
    }

    public function rules(): array
    {
        $rules = [
            'symbol' => ['required', 'string', 'exists:currencies,symbol'],
            'payment_system' => ['required', 'string'],
            'amount' => ['required'],
        ];

        if ($this->symbol && $this->isFiat($this->symbol) && $this->depositType !== 'online') {
            $rules['amount'] = ['required', 'regex:/^\d+(\.\d{1,8})?$/'];
            $rules['bank_account_id'] = ['required', 'integer', new ValidUserBankAccount()];
        }

        return $rules;
    }

    protected function isFiat(?string $symbol): bool
    {
        if (!$symbol) return false;

        $currency = Currency::where('symbol', $symbol)->first();
        return $currency && $currency->type === 'fiat';
    }

    protected function failedValidation(\Illuminate\Contracts\Validation\Validator $validator)
    {
        throw new \Illuminate\Validation\ValidationException($validator, response()->json([
            'status' => 'error',
            'errors' => $validator->errors()
        ], 422));
    }
}
