<?php

namespace App\Http\Controllers\dashboard\transaction;
use App\Http\Controllers\Controller;
use App\Services\transaction\TransactionReportService;
use Illuminate\Http\Request;

class TransactionReportController extends Controller
{
    protected $reportService;

    public function __construct(TransactionReportService $reportService)
    {
        $this->reportService = $reportService;
    }

    // 1- لیست همه تراکنش‌ها
    public function index()
    {
        $transactions = $this->reportService->getAllTransactions();
        return response()->json(['data' => $transactions]);
    }

    // 2- لیست تراکنش‌ها بر اساس wallet_id
    public function byWallet($walletId)
    {
        $transactions = $this->reportService->getTransactionsByWalletId($walletId);
        return response()->json(['data' => $transactions]);
    }

    // 3- لیست تراکنش‌ها بر اساس ارز
    public function byCurrency($currency)
    {
        $transactions = $this->reportService->getTransactionsByCurrency($currency);
        return response()->json(['data' => $transactions]);
    }

    // 4- فیلتر تراکنش‌ها
    public function filter(Request $request)
    {
        $filters = $request->only(['currency', 'transaction_type', 'date_from', 'date_to']);

        $transactions = $this->reportService->filterTransactions($filters);

        return response()->json(['data' => $transactions]);
    }
}
