<?php

namespace App\Http\Controllers\Dashboard\Bank;
use App\Http\Controllers\Controller;
use App\Http\Requests\BankAccountRequest;
use App\Services\bank\BankAccountService;
use App\Http\Requests\UserBankAccountRequest;
use Illuminate\Http\Request;
use Auth;
class BankController extends Controller
{
    protected $bankAccountService;

    public function __construct(BankAccountService $bankAccountService)
    {
        $this->bankAccountService = $bankAccountService;
    }

    public function addBank(BankAccountRequest $request)
    {
    $user = Auth::user();
    if (!$user) {
        return response()->json([
            'status' => 'error',
            'message' => 'Unauthorized'
        ], 401);
    }

    // حذف user_id از validated چون از توکن میاد
    $data = $request->validated();
    $data['user_id'] = $user->id;

    $result = $this->bankAccountService->handleBankAccount($data);

    if ($result['status'] === 'error') {
        return response()->json([
            'status' => 'error',
            'message' => $result['message']
        ], 422);
    }

    return response()->json([
        'status' => 'success',
        'message' => $result['message'],
        'data' => $result['data']
    ]);

    }

    public function getUserBankAccounts(UserBankAccountRequest $request)
    {
    $user = Auth::user();

    if (!$user) {
        return response()->json(['message' => 'Unauthorized'], 401);
    }

    $validated = $request->validated();

    $result = $this->bankAccountService->getUserBankAccounts(
        $user->id,
        $validated['currency_type']
    );

    return response()->json(['data' => $result]);
   }
}
