<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateWalletsInternalTable extends Migration
{
    public function up()
    {
        Schema::create('wallets_internal', function (Blueprint $table) {
            $table->id();

            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('currency_id')->constrained()->onDelete('cascade');

            $table->enum('type', ['fiat', 'crypto'])->default('crypto');

            $table->string('address')->unique();

            $table->decimal('balance', 30, 18)->default(0);
            $table->decimal('balance_frozen', 30, 18)->default(0);

            $table->boolean('is_active')->default(true);

            $table->boolean('is_essential')->default(false);
            $table->timestamps();

            $table->index(['user_id', 'currency_id']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('wallets_internal');
    }
}
