<?php

namespace App\Services\user;

use App\Models\User;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\ValidationException;

class UserProfileService
{

 public function updateProfile(int $userId, array $data): array
    {
        $user = User::find($userId);

        if (!$user) {
            return ['status' => 'error', 'message' => 'کاربر یافت نشد.'];
        }

        if ($user->user_level !== 0) {
            return ['status' => 'error', 'message' => 'شما اجازه تغییر اطلاعات را ندارید.'];
        }

        $user->update($data);

        return ['status' => 'success', 'message' => 'اطلاعات کاربر با موفقیت به‌روزرسانی شد.', 'data' => $user];
    }


}
