<?php

namespace App\Http\Controllers\Dashboard\Bank;
use App\Http\Controllers\Controller;
use App\Http\Requests\BankAccountRequest;
use App\Services\bank\BankAccountService;
use App\Http\Requests\UserBankAccountRequest;
use Illuminate\Http\Request;
use Auth;
class BankController extends Controller
{
    protected $bankAccountService;

    public function __construct(BankAccountService $bankAccountService)
    {
        $this->bankAccountService = $bankAccountService;
    }

     public function addBank(BankAccountRequest $request)
{
    $timestamp = now()->toIso8601String();
    $version = 'v1';

    $user = Auth::user();

    if (!$user) {
        return response()->json([
            'status' => 'error',
            'message' => 'Unauthorized',
            'meta' => [
                'timestamp' => $timestamp,
                'version' => $version
            ]
        ], 401);
    }

    // حذف user_id از validated چون از توکن میاد
    $data = $request->validated();
    $data['user_id'] = $user->id;

    $result = $this->bankAccountService->handleBankAccount($data);

    if ($result['status'] === 'error') {
        return response()->json([
            'status' => 'error',
            'message' => $result['message'],
            'meta' => [
                'timestamp' => $timestamp,
                'version' => $version
            ]
        ], 422);
    }

    return response()->json([
        'status' => 'success',
        'message' => $result['message'],
        'data' => $result['data'],
        'meta' => [
            'timestamp' => $timestamp,
            'version' => $version
        ]
    ]);
}

public function getUserBankAccounts(UserBankAccountRequest $request)
{
    $timestamp = now()->toIso8601String();
    $version = 'v1';

    $user = Auth::user();

    if (!$user) {
        return response()->json([
            'status' => 'error',
            'message' => 'Unauthorized',
            'meta' => [
                'timestamp' => $timestamp,
                'version' => $version
            ]
        ], 401);
    }

    $validated = $request->validated();

    $result = $this->bankAccountService->getUserBankAccounts(
        $user->id,
        $validated['currency_type']
    );

    return response()->json([
        'status' => 'success',
        'message' => 'Bank accounts retrieved successfully',
        'data' => $result,
        'meta' => [
            'timestamp' => $timestamp,
            'version' => $version
        ]
    ]);
}

}
