<?php

namespace App\Http\Controllers\Shared;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Setting;
use App\Models\Slider;
class SliderController extends Controller
{
 public function getSliders(): JsonResponse
{
    $timestamp = now()->toIso8601String();
    $version = 'v1';

    // پیدا کردن تنظیمات بر اساس ID
    $setting = Setting::where('is_active', true)->first();

    // اگر تنظیمات پیدا نشد
    if (!$setting) {
        return response()->json([
            'status' => 'error',
            'message' => 'تنظیمات یافت نشد.',
            'error' => [
                'code' => 'SETTING_NOT_FOUND',
                'details' => 'هیچ تنظیماتی با وضعیت فعال یافت نشد.'
            ],
            'meta' => [
                'timestamp' => $timestamp,
                'version' => $version
            ]
        ], 404);
    }

    // فرستادن اطلاعات اسلایدرها به فرانت‌اند
    $sliders = $setting->sliders->map(function ($slider) {
        return [
            'image' => $slider->image,
            'title' => $slider->title,
            'description' => $slider->description,
            'slug' => $slider->slug,
        ];
    });

    // در صورتی که تنظیمات و اسلایدرها پیدا شوند
    return response()->json([
        'status' => 'success',
        'message' => 'اسلایدرها با موفقیت بارگذاری شدند.',
        'data' => $sliders,
        'meta' => [
            'timestamp' => $timestamp,
            'version' => $version
        ]
    ]);
}

}
